VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TagMP3"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'variables locales para almacenar los valores de las propiedades
Private mvarAlbum As String * 30 'copia local
Private mvarArtista As String * 30 'copia local
Private mvarComentario As String * 30 'copia local
Private Comentario28 As String * 28 'copia local
Private mvarFichero As String 'copia local
Private mvarTitulo As String * 30 'copia local
Private mvarAo As String * 4 'copia local
Private mvarTieneTag As Boolean 'copia local
Private mvarCodigoGenero As Long 'copia local
Private mvarDescrGenero As String 'copia local
Private mvarPista As Byte 'copia local
'lista de generos musicales
Private ListaGeneros As Variant

Public Property Let Pista(ByVal vData As Byte)
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Pista = 5
    mvarPista = vData
End Property


Public Property Get Pista() As Byte
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Pista
    Pista = mvarPista
End Property



Public Sub RellenaListaGeneros(Lista As Object)
Dim i As Long

Lista.Clear
For i = 0 To UBound(ListaGeneros)
    Lista.AddItem ListaGeneros(i)
    Lista.ItemData(Lista.NewIndex) = i
Next i
'el ltimo tiene el id 255
Lista.ItemData(Lista.NewIndex) = 255
End Sub

Private Function DameGenero(Codigo As Long) As String
If Codigo >= 0 And Codigo < 148 Then
    DameGenero = ListaGeneros(Codigo)
Else
    DameGenero = ListaGeneros(148)
End If
End Function

Public Function Grabar() As Boolean
Attribute Grabar.VB_Description = "Grabar los tags MP3 en el fichero"
Dim Fich As Integer

On Error GoTo Grabar_Err

Fich = FreeFile
Open mvarFichero For Binary As Fich

If mvarTieneTag Then
    Put Fich, FileLen(mvarFichero) - 127, "TAG"
Else
    Put Fich, FileLen(mvarFichero), "TAG"
End If

Put Fich, , mvarTitulo
Put Fich, , mvarArtista
Put Fich, , mvarAlbum
Put Fich, , mvarAo
If mvarPista <> 0 Then
    Comentario28 = mvarComentario
    Put Fich, , Comentario28
    Put Fich, , Chr$(0)
    Put Fich, , Chr$(mvarPista)
Else
    Put Fich, , mvarComentario
End If
Put Fich, , Chr$(mvarCodigoGenero)

Close Fich

Grabar = True
Exit Function

Grabar_Err:
    On Error Resume Next
    Grabar = False
    Close Fich
Exit Function


End Function

Public Function Leer() As Boolean
Attribute Leer.VB_Description = "Leer los tags MP3 del fichero"
Dim Fich As Integer
Dim strTag As String * 128

'inicializo las propiedades
mvarAlbum = "": mvarAo = "": mvarArtista = "": mvarComentario = ""
mvarTieneTag = False: mvarTitulo = "": mvarCodigoGenero = 255

On Error GoTo Leer_Err
'los tags ocupan 128 bytes, luego el fichero debe medir ms
If FileLen(mvarFichero) > 128 Then
    Fich = FreeFile
    Open mvarFichero For Binary As Fich
    Get Fich, FileLen(mvarFichero) - 127, strTag
    'Comprobamos si tiene tags
    If Left$(strTag, 3) = "TAG" Then
        'asignamos el valor a las propiedades
        mvarAlbum = Mid$(strTag, 64, 30)
        mvarAo = Mid$(strTag, 94, 4)
        mvarArtista = Mid$(strTag, 34, 30)
        mvarComentario = Mid$(strTag, 98, 30)
        'si el caracter 29 del comentario es un &H0 significa que el tag es de la versin 1.1
        'y entonces el comentario slo son 28 y en la 30 est el nmero de pista
        If Asc(Mid(mvarComentario, 29, 1)) = 0 Then
            mvarPista = Asc(Right(mvarComentario, 1))
            mvarComentario = Left(mvarComentario, 28)
        Else
            mvarPista = 0
        End If
        mvarTieneTag = True
        mvarTitulo = Mid$(strTag, 4, 30)
        mvarCodigoGenero = Asc(Right$(strTag, 1))
    End If
    Close Fich
End If
Leer = True
Exit Function

Leer_Err:
    On Error Resume Next
    Leer = False
    Close Fich
Exit Function


End Function



Public Property Get DescrGenero() As String
Attribute DescrGenero.VB_Description = "Nombre del gnero musical definido en la propiedad CodigoGenero"
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.DescrGenero
    DescrGenero = mvarDescrGenero
End Property



Public Property Let CodigoGenero(ByVal vData As Long)
Attribute CodigoGenero.VB_Description = "Cdigo del gnero musical al que pertenece el tema"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.CodigoGenero = 5
    mvarCodigoGenero = IIf(vData > 147 Or vData < 0, 255, vData)
    mvarDescrGenero = DameGenero(mvarCodigoGenero)
End Property

Public Property Get CodigoGenero() As Long
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.CodigoGenero
    CodigoGenero = mvarCodigoGenero
End Property





Public Property Get TieneTag() As Boolean
Attribute TieneTag.VB_Description = "Indica si el fichero contiene tags MP3"
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.TieneTag
    TieneTag = mvarTieneTag
End Property



Public Property Let Ao(ByVal vData As String)
Attribute Ao.VB_Description = "Ao de publicacin del tema"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Ao = 5
    mvarAo = vData
End Property


Public Property Get Ao() As String
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Ao
    Ao = Trim(mvarAo)
End Property



Public Property Let Titulo(ByVal vData As String)
Attribute Titulo.VB_Description = "Ttulo del tema"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Titulo = 5
    mvarTitulo = vData
End Property


Public Property Get Titulo() As String
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Titulo
    Titulo = Trim(mvarTitulo)
End Property



Public Property Let Fichero(ByVal vData As String)
Attribute Fichero.VB_Description = "Nombre del fichero mp3"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Fichero = 5
    mvarFichero = vData
End Property


Public Property Get Fichero() As String
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Fichero
    Fichero = mvarFichero
End Property



Public Property Let Comentario(ByVal vData As String)
Attribute Comentario.VB_Description = "Comentario sobre el tema"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Comentario = 5
    mvarComentario = vData
End Property


Public Property Get Comentario() As String
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Comentario
    Comentario = Trim(mvarComentario)
End Property



Public Property Let Artista(ByVal vData As String)
Attribute Artista.VB_Description = "Intrprete del tema"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Artista = 5
    mvarArtista = vData
End Property


Public Property Get Artista() As String
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Artista
    Artista = Trim(mvarArtista)
End Property



Public Property Let Album(ByVal vData As String)
Attribute Album.VB_Description = "Ttulo del album al que pertenece el tema"
'se usa al asignar un valor a la propiedad, en la parte izquierda de una asignacin.
'Syntax: X.Album = 5
    mvarAlbum = vData
End Property


Public Property Get Album() As String
'se usa al recuperar un valor de una propiedad, en la parte derecha de una asignacin.
'Syntax: Debug.Print X.Album
    Album = Trim(mvarAlbum)
End Property



Private Sub Class_Initialize()
ListaGeneros = Array("Blues", "Rock Clsico", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", _
                        "New Age", "Oldies", "Otro", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", _
                        "Alternativo", "Ska", "Death Metal", "Pranks", "Bandas sonoras", "Euro-Techno", "Ambiente", "Trip-Hop", "Vocal", "Jazz+Funk", _
                        "Fusion", "Trance", "Msica Clsica", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", _
                        "Rock Alternativo", "Bass", "Soul", "Punk", "Space", "Meditative", "Pop Instrumental", "Rock Instrumental", "Ethnic", "Gtico", _
                        "Darkwave", "Techno-Industrial", "Electrnica", "Pop-Folk", "Eurodance", "Dream", "Rock Sureo", "Comedia", "Culto", "Gangsta", _
                        "Top 40", "Rap Cristiano", "Pop/Funk", "Jungle", "Native American ", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", _
                        "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", _
                        "Folk", "Folk-Rock", "Folk Nacional", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celta", "Bluegrass", _
                        "Avantgarde", "Rock Gtico", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acstico", _
                        "Humor", "Discruso", "Chanson", "Opera", "Chamber Music", "Sonata", "Sinfona", "Booty Bass", "Primus", "Porn Groove", _
                        "Stira", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Balada", "Power Ballad", "Rhythmic Soul", "Freestyle", _
                        "Dueto", "Punk Rock", "Drum Solo", "Acapella", "Euro-House", "Dance Hall", "Goa", "Drum And Bass", "ClubHouse", "Hardcore", _
                        "Terror", "Indie", "Pop Britnico", "Punk Negro", "Punk Polaco", "Beat", "Rap Cristiano", "HeavyMetal", "BlackMetal", "Crossover", _
                        "Christiano Contemporneo", "Rock Cristiano", "Merengue", "Salsa", "TrashMetal", "Anime", "JPop", "SynthPop", "Ninguno")

End Sub


